<?php

namespace Daylight\Connector\Providers;

use Daylight\Core\Http\Controllers\Content\PageController;
use Daylight\Core\Http\Controllers\DashboardController;
use Daylight\Core\Http\Controllers\Settings\CountryController;
use Daylight\Core\Http\Controllers\Settings\GeneralSettingsController;
use Daylight\Core\Http\Controllers\Settings\RoleController;
use Daylight\Core\Http\Controllers\Settings\ShippingClassController;
use Daylight\Core\Http\Controllers\Settings\ShippingZoneController;
use Daylight\Core\Http\Controllers\Settings\TaxClassController;
use Daylight\Core\Http\Controllers\Store\AttributeController;
use Daylight\Core\Http\Controllers\Store\BrandController;
use Daylight\Core\Http\Controllers\Store\CategoryController;
use Daylight\Core\Http\Controllers\Store\CustomerController;
use Daylight\Core\Http\Controllers\Store\CustomerGroupController;
use Daylight\Core\Http\Controllers\Store\LabelController;
use Daylight\Core\Http\Controllers\Store\OrderController;
use Daylight\Core\Http\Controllers\Store\ProductController;
use Daylight\Core\Http\Controllers\Store\UserController;
use Daylight\Core\Http\Controllers\Store\VariantController;
use Daylight\Core\Modules\MediaLibrary\Http\Controllers\API\DirectoryController;
use Daylight\Core\Modules\MediaLibrary\Http\Controllers\API\MediaController as MediaApiController;
use Daylight\Core\Modules\MediaLibrary\Http\Controllers\MediaController;
use Daylight\Core\Modules\MenuBuilder\Http\Controllers\MenuController;
use Daylight\Core\Modules\MenuBuilder\Http\Controllers\NavigationSettingsController;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Spatie\ResponseCache\Middlewares\DoNotCacheResponse;

/**
 * Class RouteServiceProvider
 * @package Daylight\Connector\Providers
 * 
 * Register a settingspage for the connector in the admin panel
 * Other connectors can use this
 */
class RouteServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        $this
            ->registerMiddleware()
            ->registerRouteMacros();
    }

    public function registerMiddleware(): self
    {
        $router = $this->app->make(Router::class);

        $router->aliasMiddleware('no-cache', DoNotCacheResponse::class);

        return $this;
    }

    public function registerRouteMacros(): self
    {
        Route::macro('connector', function (string $path = 'admin') {
            Route::middleware(['web', 'auth', 'can:view:administration', 'no-cache'])
                ->name('daylight.')
                ->prefix($path)
                ->group(function () {

                    Route::prefix('settings')
                        ->as('settings.')
                        ->group(function () {
                            Route::get('/connector', [NavigationSettingsController::class, 'index'])->name('navigation.index');
                            Route::put('/connector', [NavigationSettingsController::class, 'update'])->name('navigation.update');
                        });

                });
        });

        return $this;
    }
}
