<?php

namespace Daylight\Connector\Registries;

use Daylight\Connector\Connector;
use Illuminate\Support\Collection;

/**
 * Class ConnectorRegistry
 * @package Daylight\Connector\Registries
 *
 * A registry to hold all registered connectors
 * Other packages can register their connectors here
 */
class ConnectorRegistry
{
    protected Collection $connectors;

    public function __construct()
    {
        $this->connectors = collect();
    }

    public function register(Connector $connector): self
    {
        $this->connectors->put($connector->getKey(), $connector);

        return $this;
    }

    public static function addConnector(Connector $connector): self
    {
        return app(ConnectorRegistry::class)->register($connector);
    }

    public function all(): Collection
    {
        return $this->connectors;
    }
}
