<?php

namespace Daylight\Connector\Resources;

use Saloon\Http\BaseResource;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;

/**
 * Class Attributes
 * @package Daylight\Connector\Resources
 *
 * Resource to handle attribute-related API requests.
 * Using this resource, you can fetch all attributes or a single attribute by its ID.
 */
class Attributes extends BaseResource
{
    /**
     * Fetch all attributes.
     */
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Attributes\\GetAttributesRequest',
            $mapper,
            $options
        );
    }

    /**
     * Fetch a single attribute by its ID.
     */
    public function get(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Attributes\\GetAttributeRequest',
            $mapper,
            $options
        );
    }
}
