<?php

namespace Daylight\Connector\Resources;

use Daylight\ConnectorCash\Requests\Customers\GetCustomersRequest;
use Saloon\Http\BaseResource;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;

/**
 * Class Customers
 * @package Daylight\Connector\Resources
 *
 * Resource to handle customer-related API requests.
 * Using this resource, you can fetch all customers or a single customer by its ID.
 */
class Customers extends BaseResource
{
    /**
     * Fetch all customers.
     */
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Customers\\GetCustomersRequest',
            $mapper,
            $options
        );
    }

    /**
     * Fetch a single customer by its ID.
     */
    public function get(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Customers\\GetCustomerRequest',
            $mapper,
            $options
        );
    }
}
