<?php

namespace Daylight\Connector\Resources;

use Saloon\Http\BaseResource;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;

/**
 * Class OrderItems
 * @package Daylight\Connector\Resources
 *
 * Resource to handle orderitem-related API requests.
 * Using this resource, you can fetch all order items or a single order item by its ID.
 */
class OrderItems extends BaseResource
{
    /**
     * Fetch all orderlines.
     */
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Orders\\getOrderItemsRequest',
            $mapper,
            $options
        );
    }

    /**
     * Fetch lines of a single order
     */
    public function get(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Orders\\getOrderItemsRequest',
            $mapper,
            $options
        );
    }
}
