<?php

namespace Daylight\Connector\Resources;

use Saloon\Http\BaseResource;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;

/**
 * Class Orders
 * @package Daylight\Connector\Resources
 *
 * Resource to handle orders-related API requests.
 * Using this resource, you can fetch all orders or a single order by its ID.
 */
class Orders extends BaseResource
{
    /**
     * Fetch all orders.
     */
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Orders\\GetOrdersRequest',
            $mapper,
            $options
        );
    }

    /**
     * Fetch a single order by its ID.
     */
    public function get(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Orders\\GetOrderRequest',
            $mapper,
            $options
        );
    }
}
