<?php

namespace Daylight\Connector\Resources;

use Saloon\Http\BaseResource;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;

/**
 * Class Prices
 * @package Daylight\Connector\Resources
 *
 * Resource to handle prices-related API requests.
 * Using this resource, you can fetch all prices or a single price by its ID.
 */
class Prices extends BaseResource
{
    /**
     * Fetch all prices.
     */
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Prices\\GetPricesRequest',
            $mapper,
            $options
        );
    }

    /**
     * Fetch a single price.
     */
    public function get(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Prices\\GetPriceRequest',
            $mapper,
            $options
        );
    }
}
