<?php

namespace Daylight\Connector\Resources;

use Saloon\Http\BaseResource;
use Saloon\Http\Response;
use Daylight\ConnectorCash\Requests\Products\GetProductsRequest;
use Daylight\Connector\Contracts\MapperInterface;

/**
 * Class Products
 * @package Daylight\Connector\Resources
 *
 * Resource to handle product-related API requests.
 * Using this resource, you can fetch all products or a single product by its ID.
 */
class Products extends BaseResource
{
    /**
     * Fetch all products.
     */
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Products\\GetProductsRequest',
            $mapper,
            $options
        );
    }

    /**
     * Fetch a single product by its ID.
     */
    public function get(string $productId): Response
    {
        return $this->connector->requestHandler(
            'Products\\GetProductRequest',
            $mapper,
            $options
        );
    }
}
