<?php

namespace Daylight\Connector\Resources;

use Daylight\ConnectorCash\Requests\Users\GetUsersRequest;
use Saloon\Http\BaseResource;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;

/**
 * Class Users
 * @package Daylight\Connector\Resources
 *
 * Resource to handle user-related API requests.
 * Using this resource, you can fetch all users or a single user by its ID.
 */
class Users extends BaseResource
{
    /**
     * Fetch all users.
     */
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Users\\GetUsersRequest',
            $mapper,
            $options
        );
    }

    /**
     * Fetch a single user by its ID.
     */
    public function get(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Users\\GetUserRequest',
            $mapper,
            $options
        );
    }
}
