<?php

namespace Daylight\Connector;

use Daylight\Core\Modules\Admin\Entities\Divider;
use Daylight\Core\Modules\Admin\Entities\Page;
use Daylight\Core\Modules\Admin\Registries\NavigationRegistry;
use Daylight\Core\Modules\MenuBuilder\Registries\MenuRegistry;
use Illuminate\Support\ServiceProvider;
use Daylight\DaylightCore\Console\InstallCommand;
use Illuminate\Routing\Router;
use Spatie\ResponseCache\Middlewares\CacheResponse;
use Spatie\ResponseCache\Middlewares\DoNotCacheResponse;
use Illuminate\Support\Facades\Blade;
use Daylight\Connector\ConnectorManager;
use Daylight\Connector\Registries\ConnectorRegistry;
use Illuminate\Console\Scheduling\Schedule;
use Daylight\Connector\Providers\RouteServiceProvider;

/**
 * Class DaylightConnectorServiceProvider
 * @package Daylight\Connector
 */
class DaylightConnectorServiceProvider extends ServiceProvider
{
    public function register()
    {
        // Register the ConnectorRegistry as a singleton
        $this->app->singleton(ConnectorRegistry::class, function () {
            return new ConnectorRegistry;
        });
        $this->app->register(RouteServiceProvider::class);

        $this->loadMigrationsFrom(__DIR__.'/../database/mimigrationsgrations');
    }

    public function boot(Schedule $schedule, ConnectorRegistry $connectorRegistry)
    {
        $this->loadViewsFrom(__DIR__.'/../resources/views', 'daylight');

        $this
            ->registerAdminNavigation()
            ->registerScheduledCommands($schedule, $connectorRegistry);
    }

    public function registerAdminNavigation(): self
    {
        NavigationRegistry::addPage(
            Page::create()
                ->setParent('settings')
                ->setOrder(900)
                ->setKey('connector')
                ->setLabel('Connector')
                ->setPermission('view:administration')
                ->setIcon('o-circle-stack')
                ->setRoute('daylight.settings.connector.index')
        );

        return $this;
    }

    public function registerScheduledCommands(Schedule $schedule, ConnectorRegistry $connectorRegistry): self
    {
        foreach ($connectorRegistry->all() as $connector) {
            foreach ($connector->commands as $command) {
                $schedule->command($command['command'], [
                    '--connector' => $connector->key
                ])->cron($command['schedule']);
            }
        }

        return $this;
    }
}
