<?php

namespace Daylight\Connector\Resources;

use Saloon\Http\BaseResource;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;

/**
 * Class Address
 * @package Daylight\Connector\Resources
 *
 * Resource to handle address-related API requests.
 * Using this resource, you can fetch all addresses or a single address by its ID.
 */
class Address extends BaseResource
{
    /**
     * Fetch all addresses.
     */
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Addresses\\GetAddressesRequest',
            $mapper,
            $options
        );
    }

    /**
     * Fetch a single address by its ID.
     */
    public function get(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Addresses\\GetAddressRequest',
            $mapper,
            $options
        );
    }
}
