# Daylight Connector Core

Een Laravel basispackage voor connectoren.
Deze package heeft alleen de basis functionaliteit en moet uitgebreid worden met een platform specifieke connector package.

## Installatie

De package wordt automatisch geladen via Composer en de Laravel service provider.

## Configuratie

Voeg onderstaande code toe aan je routes/web.php zodat de Connector settings pagina beschikbaar komt:
```php
    Route::connector();
```

## Gebruik

- Maak een class voor je [Platform] en extend Daylight\Connector\Services\BaseConnector, bijvoorbeeld:
```php
    use Daylight\Connector\Services\BaseConnector;
    
    class Cash extends BaseConnector
    {
        protected string $name = 'Visma Cash';
        protected string $namespace = 'Daylight\ConnectorCash';
```
- Registreer de specifieke connector class de nieuwe DaylightConnector[Platform]ServiceProvider
```php
    public function boot()
    {
         ConnectorRegistry::addConnector(
            Connector::create()
                ->setKey('[Platform]')
                ->setConnector(Cash::class)
                ->setCommands();
    }
```
- Extend resources, connectoren e.d. vanuit deze connector
- Commands komen de platform specifieke connector package
- Bestanden in /Requests moeten overeenkomen met de paden in /connector-core/Resources/[Entity].php
- Mapperen van data gebeurt in de platform specifieke connector package
