<?php

namespace Daylight\Connector\Exceptions;

use Exception;
use Saloon\Http\Response;

class RequestFailedException extends Exception
{
    protected Response $response;

    protected ?string $method = null;

    protected ?string $url = null;

    protected ?array $query = [];

    public static function for(Response $response, ?string $method = null, ?string $uri = null, array $query = []): static
    {
        $instance = new static('Request Failed: ' . $response->body());

        $instance->response = $response;
        $instance->method = $method;
        $instance->url = $uri;
        $instance->query = $query;

        return $instance;
    }

    public function context(): array
    {
        return [
            'response' => $this->response->body(),
            'method' => $this->method,
            'url' => $this->url,
            'query' => $this->query,
        ];
    }
}
