<?php

namespace Daylight\Connector\Services;

use Daylight\Connector\Http\ConnectionConfig;
use Daylight\Connector\Support\ConnectorLogger;
use Illuminate\Http\Client\Response;
use Saloon\Http\Connector;
use Saloon\Traits\Plugins\HasTimeout;
use Saloon\Http\Auth\TokenAuthenticator;
use Daylight\Connector\Resources\Products;
use Daylight\Connector\Resources\Customers;
use Daylight\Connector\Resources\Users;
use Daylight\Connector\Resources\Orders;
use Daylight\Connector\Resources\OrderItems;
use Daylight\Connector\Resources\Address;

/**
 * Class BaseConnector
 * @package Daylight\Connector\Services
 *
 * The base connector class for all connectors.
 */
class BaseConnector extends Connector
{
    use HasTimeout;

    protected int $connectTimeout = 30;
    protected int $requestTimeout = 60;

    protected ConnectorLogger $logger;

    public function __construct(
        ConnectorLogger $logger
    )
    {
        $this->logger = $logger;
    }

    public function resolveBaseUrl(): string
    {
        //
    }

    /**
     * Init the logger instance.
     */
    public function logger(): ConnectorLogger
    {
        return $this->logger;
    }

    public function products(): mixed
    {
        return new Products($this);
    }

    public function customers(): Customers
    {
        return new Customers($this);
    }

    public function users(): Users
    {
        return new Users($this);
    }

    public function orders(): Orders
    {
        return new Orders($this);
    }

    public function orderItems(): OrderItems
    {
        return new OrderItems($this);
    }

    public function addresses(): Address
    {
        return new Address($this);
    }
}
