<?php

namespace Daylight\Connector\Exceptions;

class RequestNotFoundException extends \Exception
{

    public static function noRequestSet(): self
    {
        return new self('No request set.');
    }

    public static function forRequest(string $request): self
    {
        return new self('Request class for "' . $request . '" not found.');
    }

}
