## Daylight Exact Online Connector

## Config
The Daylight Exact Online Connector is configured using the `services.php` file. Your .env file contains the necessary settings to connect to the Exact Online API and manage the integration.

### Add the following lines to your `config/services.php` file:

```php
'exact' => [
    'client_id' => env('EXACT_CLIENT_ID'),
    'client_secret' => env('EXACT_CLIENT_SECRET'),
    'redirect_uri' => env('EXACT_REDIRECT_URI'),
    'webhook_secret' => env('EXACT_WEBHOOK_SECRET'),
    'division' => env('EXACT_DIVISION'),
],
```

### Add the following lines to your `.env` file:

```dotenv
EXACT_CLIENT_ID=
EXACT_CLIENT_SECRET=
EXACT_REDIRECT_URI=
EXACT_WEBHOOK_SECRET=
EXACT_DIVISION=
```

### Get your Exact Online API credentials
To obtain your Exact Online API credentials, follow these steps:

```bash
php artisan exact:install
```

### Subscribe to the webhooks
To subscribe to the Exact Online webhooks, run the following command:

```bash
php artisan exact:subscribe-webhooks
```

### Configure scheduling
To ensure data integrity and timely updates, the connector requires scheduled tasks. You can set up these tasks in your application's scheduler.

Add the following lines to your `routes/console.php` file:

```php
Schedule::call(UpdateUnits::class)->daily();
Schedule::call(UpdateCustomers::class)->hourlyAt(0);
Schedule::call(UpdateAddresses::class)->hourlyAt(5);
Schedule::call(UpdateArticles::class)->everyFourHours(0);
Schedule::call(UpdateArticlePrices::class)->everyFourHours(15);
Schedule::call(UpdateArticleCharges::class)->everyFourHours(30);
Schedule::call(UpdatePricingLists::class)->everyFourHours(30);
Schedule::call(UpdatePricingListPeriods::class)->everyFourHours(30);
Schedule::call(UpdatePricingListLines::class)->everyFourHours(30);
Schedule::call(UpdateOrders::class)->hourlyAt(0);
Schedule::call(UpdateOrderLines::class)->hourlyAt(5);
Schedule::call(UpdateContacts::class)->everyFifteenMinutes();
```