<?php

namespace Daylight\Connector\Exact\Console\Commands;

use Daylight\Connector\Exact\Exact;
use Illuminate\Console\Command;

class SubscribeWebhooks extends Command
{
    protected $signature = 'exact:subscribe-webhooks';

    protected $description = 'Subscribe to Exact Online webhooks';

    public function handle(Exact $connector): int
    {
        $this->info('Subscribing to Exact Online webhooks...');

        collect([
            'Accounts',
            'Contacts',
            'Items',
            'SalesOrders',
            //            'SalesOrderLines'
        ])->each(function ($topic) use ($connector) {
            $this->line("Subscribing to topic: $topic..");

            $response = $connector->webhooks()->subscribe($topic);

            if ($response->successful()) {
                $this->info("Successfully subscribed to $topic");
            } else {
                $this->error("Failed to subscribe to $topic: ".$response->body());
            }
        });

        return Command::SUCCESS;
    }
}
