<?php

namespace Daylight\Connector\Exact\Jobs;

use Daylight\Connector\Exact\Entities\ProductCharge;
use Daylight\Core\Models\TaxClass;
use Daylight\Core\Models\Variant;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateProductCharge implements ShouldBeEncrypted, ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public ProductCharge $productCharge
    ) {
        //
    }

    public function handle(): void
    {
        $variant = $this->getVariant();

        if (! $variant) {
            return;
        }

        $variant->charges()->updateOrCreate([
            'external_id' => $this->productCharge->id,
        ], [
            'tax_class_id' => $this->getTaxClass()?->id,
            'quantity' => $this->productCharge->quantity,
            'price' => $this->productCharge->amount,
            'description' => $this->productCharge->description,
            'code' => $this->productCharge->chargeCode,
            'external_charge_id' => $this->productCharge->chargeId,
        ]);
    }

    public function getVariant(): ?Variant
    {
        return Variant::query()
            ->whereExternalId($this->productCharge->productId)
            ->first();
    }

    public function getTaxClass(): ?TaxClass
    {
        return TaxClass::query()
            ->where('code', $this->productCharge->taxCode)
            ->first();
    }
}
