<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\Customer;

class CustomerMapper implements MapperInterface
{
    public function map(array $data): Customer
    {
        return Customer::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): Customer
    {
        return Customer::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
