<?php

namespace Daylight\Connector\Exact\Models;

use Daylight\Connector\Exact\Models\Casts\EncryptedAccessTokenAuthenticator;
use Illuminate\Database\Eloquent\Model;

class OAuthToken extends Model
{
    protected $table = 'exact_oauth_tokens';

    protected $guarded = [];

    protected $casts = [
        'authenticator' => EncryptedAccessTokenAuthenticator::class,
    ];

    public function getAccessToken(): ?string
    {
        $auth = $this->authenticator;

        return $auth?->getAccessToken();
    }
}
