<?php

namespace Daylight\Connector\Exact\Requests\Contacts;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\ContactMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetContactsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected ContactMapper $contactMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/sync/CRM/Contacts';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                'Timestamp',
                'Account',
                'AccountIsCustomer',
                'Email',
                'EndDate',
                'FirstName',
                'IsAnonymised',
                'IsMainContact',
                'Language',
                'LastName',
                'MiddleName',
                'Mobile',
                'StartDate',
            ]),
            '$skiptoken' => $this->options['skiptoken'] ?? null,
            '$filter' => $this->options['cursor'] ? "Timestamp gt {$this->options['cursor']}L" : null,
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->contactMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
