<?php

namespace Daylight\Connector\Exact\Requests\Customers;

use Daylight\Connector\Exact\Entities\Customer;
use Daylight\Connector\Exact\Mappers\CustomerMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetCustomerRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected CustomerMapper $customerMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        $guidFilter = isset($this->options['id'])
            ? "(guid'{$this->options['id']}')"
            : null;

        return '/api/v1/'.config('services.exact.division').'/CRM/Accounts'.$guidFilter;
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                //                'Timestamp',
                'Name',
                'PaymentConditionSales',
                'SalesVATCode',
                'VATNumber',
                'PriceList',

                'Status',
                'IsSales',
                'Blocked',
                'IsAnonymised',
                'StartDate',
                'EndDate',

                // Billing address
                'AddressLine1',
                'AddressLine2',
                'AddressLine3',
                'Postcode',
                'City',
                'Country',
            ]),
        ]);
    }

    public function createDtoFromResponse(Response $response): ?Customer
    {
        return $this->customerMapper->map($response->json('d'));
    }
}
