<?php

namespace Daylight\Connector\Exact\Requests\Products;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\ProductMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetProductsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected ProductMapper $productMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/sync/Logistics/Items';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                'Timestamp',
                'Code',
                'Description',
                'IsStockItem',
                'IsWebshopItem',
                'Stock',
                'Unit',
                'PictureUrl',
                'ItemGroup',
                'ItemGroupCode',
                'ItemGroupDescription',
                'SalesVatCode',
            ]),
            '$skiptoken' => $this->options['skiptoken'] ?? null,
            '$filter' => $this->options['cursor'] ? "Timestamp gt {$this->options['cursor']}L" : null,
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->productMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
