<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('charges', function (Blueprint $table) {
            $table->id();
            $table->foreignId('variant_id')->constrained()->cascadeOnDelete();
            $table->integer('quantity')->default(1);
            $table->integer('price');
            $table->string('description');
            $table->string('code');
            $table->string('external_charge_id');
            $table->string('external_id');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::drop('charges');
    }
};
