<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('tax_classes', function (Blueprint $table) {
            $table->renameColumn('external_id', 'code');
            $table->string('external_id')->nullable()->after('code');
        });
    }

    public function down(): void
    {
        Schema::table('tax_classes', function (Blueprint $table) {
            $table->dropColumn('external_id');
            $table->renameColumn('code', 'external_id');
        });
    }
};
