<?php

namespace Daylight\Connector\Exact\Entities;

use Carbon\Carbon;
use Daylight\Connector\Entities\Product as BaseProduct;
use Daylight\Connector\Exact\Entities\Casts\TimestampDateCast;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Attributes\WithCast;

class DiscountPrice extends BaseProduct
{
    public function __construct(
        #[MapInputName('ID')]
        public string $id,

        #[MapInputName('PriceListCode')]
        public string $priceListCode,

        #[MapInputName('PriceListPeriod')]
        public string $priceListPeriodId,

        #[MapInputName('ItemGroup')]
        public string $productGroupId,

        #[MapInputName('Item')]
        public string $productId,

        #[MapInputName('StartDate')]
        #[WithCast(TimestampDateCast::class)]
        public ?Carbon $startDate,

        #[MapInputName('EndDate')]
        #[WithCast(TimestampDateCast::class)]
        public ?Carbon $endDate,
    ) {
        //
    }

}
