<?php

namespace Daylight\Connector\Exact\Entities;

use Carbon\Carbon;
use Daylight\Connector\Entities\Order as BaseOrder;
use Daylight\Connector\Exact\Entities\Casts\TimestampDateCast;
use Illuminate\Support\Collection;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Attributes\WithCast;

class Order extends BaseOrder
{
    public function __construct(
        #[MapInputName('OrderID')]
        public string $id,

        #[MapInputName('OrderNumber')]
        public int $orderNumber,

        #[MapInputName('OrderDate')]
        #[WithCast(TimestampDateCast::class)]
        public Carbon $orderDate,

        #[MapInputName('DeliveryAddress')]
        public string $deliveryAddressId,

        #[MapInputName('InvoiceTo')]
        public string $customerId,

        #[MapInputName('ApprovalStatus')]
        public int $approvalStatus,

        #[MapInputName('Status')]
        public int $status,

        #[MapInputName('PaymentCondition')]
        public string $paymentCondition,

        #[MapInputName('AmountFCExclVat')]
        public float $amountExcludingTax,

        #[MapInputName('AmountFC')]
        public float $amountIncludingTax,

        #[MapInputName('OrderedByContactPerson')]
        public ?string $authorId,

        #[MapInputName('YourRef')]
        public ?string $reference,

        #[MapInputName('Remarks')]
        public ?string $notes,

        #[MapInputName('ShippingMethod')]
        public ?string $shippingMethodId,

        #[MapInputName('PaymentReference')]
        public ?string $paymentReference,

        #[MapInputName('SalesOrderLines.results')]
        #[DataCollectionOf(OrderLine::class)]
        public Collection $orderLines,
    ) {
        //
    }

}
