<?php

namespace Daylight\Connector\Exact\Entities;

use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Data;

class PricingListLine extends Data
{
    public function __construct(
        #[MapInputName('ID')]
        public ?string $id,

        #[MapInputName('Timestamp')]
        public ?int $timestamp,

        #[MapInputName('Item')]
        public ?string $productId = null,

        #[MapInputName('ItemGroup')]
        public ?string $productGroupId = null,

        #[MapInputName('PriceListPeriod')]
        public ?string $priceListPeriodId = null,

        #[MapInputName('PriceListCode')]
        public ?string $priceListCode = null,

        #[MapInputName('Quantity')]
        public int $quantity = 1,

        #[MapInputName('BasePrice')]
        public ?string $basePriceId = null,

        #[MapInputName('BasePriceAmount')]
        public ?float $basePriceAmount = null,

        #[MapInputName('NewPrice')]
        public ?float $price = null,

        #[MapInputName('EntryMethod')]
        public int $discountMethod = 1,

        #[MapInputName('Discount')]
        public float $discountMultiplier = 0,
    ) {
        // customer_group_id => pricelist_id
        // customer_id => null
        // variant_id => product_id
        // price => Zie onderstaand
        // quantity => quantity
        // starts_at => Lookup from period
        // ends_at => Lookup from period
        // source => price-list
        // external_id => ID

        // Prijs berekenen (EntryMethod, NewPrice, BasePriceAmount, Discount)
        // Wanneer EntryMethod === 2 -> price = NewPrice
        // Wanneer EntryMethod === 1 -> price = BasePriceAmount (Ophalen uit basis prijzen) * (1 - Discount/100)
    }

}
