<?php

namespace Daylight\Connector\Exact\Jobs;

use Daylight\Connector\Exact\Entities\Contact;
use Daylight\Core\Events\UserImported;
use Daylight\Core\Models\Customer;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Str;

class UpdateContact implements ShouldBeEncrypted, ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public Contact $contact
    ) {
        //
    }

    public function handle(): void
    {
        if (! $this->contact->shouldBeImported()) {
            return;
        }

        $customer = $this->getCustomer();

        if (! $customer) {
            return;
        }

        $existingUser = $customer->users()
            ->where('external_id', $this->contact->id)
            ->first();

        if ($this->contact->leadPurpose !== '6bf5b36b-0ebd-48fa-b140-cdc617b7c013') {
            $existingUser?->delete();

            return;
        }

        try {
            $user = $customer->users()->updateOrCreate([
                'external_id' => $this->contact->id,
            ], [
                'name' => $this->contact->getFirstName(),
                'last_name' => $this->contact->getLastName(),
                'email' => $this->contact->email,
                'email_verified_at' => now(),
                'phone' => $this->contact->phone,
                'locale' => $this->contact->getLocale(),
                'password' => bcrypt(Str::password()),
            ]);

            if ($user->wasRecentlyCreated) {
                event(new UserImported($user));
            }
        } catch (\Exception $e) {
            $this->fail('Failed to create user: '.$e->getMessage());
        }
    }

    public function getCustomer(): ?Customer
    {
        return daylightModel('customer')::query()
            ->whereExternalId($this->contact->accountId)
            ->first();
    }
}
