<?php

namespace Daylight\Connector\Exact\Jobs;

use Daylight\Connector\Exact\Entities\PricingListPeriod;
use Daylight\Core\Models\CustomerGroup;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdatePricingListPeriod implements ShouldBeEncrypted, ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public PricingListPeriod $pricingListPeriod
    ) {
        //
    }

    public function handle(): void
    {
        $customerGroup = CustomerGroup::where('external_id', $this->pricingListPeriod->priceListId)->first();

        if (! $customerGroup) {
            return;
        }

        $customerGroup->periods()->updateOrCreate([
            'external_id' => $this->pricingListPeriod->id,
        ], [
            'starts_at' => $this->pricingListPeriod->startDate?->toDateString(),
            'ends_at' => $this->pricingListPeriod->endDate?->toDateString(),
        ]);
    }
}
