<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\Product;

class ProductMapper implements MapperInterface
{
    public function map(array $data): Product
    {
        return Product::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): Product
    {
        return Product::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
