<?php

namespace Daylight\Connector\Exact\Requests\Products;

use Daylight\Connector\Entities\Product;
use Daylight\Connector\Exact\Mappers\ProductMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetProductRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected ProductMapper $productMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        $guidFilter = isset($this->options['id'])
            ? "(guid'{$this->options['id']}')"
            : null;

        return '/api/v1/'.config('services.exact.division').'/bulk/Logistics/Items'.$guidFilter;
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                'Code',
                'Description',
                'IsStockItem',
                'IsWebshopItem',
                'Stock',
                'Unit',
                'PictureUrl',
                'ItemGroup',
                'ItemGroupCode',
                'ItemGroupDescription',
                'SalesVatCode',
            ]),
        ]);
    }

    public function createDtoFromResponse(Response $response): Product
    {
        $formattedResponse = $response->json('d');

        return $this->productMapper->map($formattedResponse);
    }
}
