<?php

namespace Daylight\Connector\Exact\Resources;

use Daylight\Connector\Contracts\MapperInterface;
use Saloon\Http\BaseResource;
use Saloon\Http\Response;

class PricingLists extends BaseResource
{
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'PricingLists\\GetPricingListsRequest',
            $mapper,
            $options
        );
    }

    public function periods(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'PricingLists\\GetPricingListPeriodsRequest',
            $mapper,
            $options
        );
    }

    public function lines(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'PricingLists\\GetPricingListLinesRequest',
            $mapper,
            $options
        );
    }
}
