<?php

namespace Daylight\Connector\Exact\Requests\Customers;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\CustomerMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetCustomersRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected CustomerMapper $customerMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/sync/CRM/Accounts';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                'Timestamp',
                'Name',
                'PaymentConditionSales',
                'SalesVATCode',
                'VATNumber',
                'PriceList',
                'ShippingMethod',
                'Status',
                'IsSales',
                'Blocked',
                'IsAnonymised',
                'StartDate',
                'EndDate',

                // Billing address
                'AddressLine1',
                'AddressLine2',
                'AddressLine3',
                'Postcode',
                'City',
                'Country',
            ]),
            '$skiptoken' => $this->options['skiptoken'] ?? null,
            '$filter' => $this->options['cursor'] ? "Timestamp gt {$this->options['cursor']}L" : null,
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->customerMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
