<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('units', function (Blueprint $table) {
            $table->id();
            $table->string('external_id')->nullable()->unique();
            $table->string('code')->nullable();
            $table->string('name')->nullable();
            $table->string('display_text')->nullable();
            $table->string('type')->nullable();
            $table->tinyInteger('active')->default(0);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::drop('units');
    }
};
