<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->foreignId('tax_class_id')->after('id')->nullable()->constrained()->nullOnDelete();
            $table->string('vat_number')->nullable()->after('name');
            $table->tinyInteger('invoice_payments')->default(0)->after('vat_number');
        });
    }

    public function down(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->dropForeign(['tax_class_id']);
            $table->dropColumn(['tax_class_id', 'vat_number', 'invoice_payments']);
        });
    }
};
