<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->tinyInteger('draft')->default(0)->after('confirmation_send_at');
            $table->string('hash')->nullable()->after('draft');
            $table->string('external_id')->nullable()->after('hash');
        });

        Schema::table('order_items', function (Blueprint $table) {
            $table->string('external_id')->nullable()->after('price');
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('draft');
            $table->dropColumn('hash');
            $table->dropColumn('external_id');
        });

        Schema::table('order_items', function (Blueprint $table) {
            $table->dropColumn('external_id');
        });
    }
};
