<?php

namespace Daylight\Connector\Exact\Entities\Casts;

use Carbon\Carbon;
use Spatie\LaravelData\Casts\Cast;
use Spatie\LaravelData\Support\Creation\CreationContext;
use Spatie\LaravelData\Support\DataProperty;

class TimestampDateCast implements Cast
{
    public function cast(
        DataProperty $property,
        mixed $value,
        mixed $properties,
        CreationContext $context
    ): ?Carbon {
        if (! $value) {
            return null;
        }

        // Handle Exact date format: "/Date(1496275200000)/"
        if (preg_match('/\/Date\((\d+)\)\//', $value, $matches)) {
            $timestamp = (int) $matches[1] / 1000; // convert ms → seconds

            return Carbon::createFromTimestamp($timestamp);
        }

        return Carbon::parse($value);
    }
}
