<?php

namespace Daylight\Connector\Exact\Entities;

use Illuminate\Support\Collection;

class PaginatedResource
{
    public ?Collection $data;

    public ?string $skipToken;

    public function __construct(?Collection $data = null, ?string $skipToken = null)
    {
        $this->data = $data ?? collect();
        $this->skipToken = $this->getSkipTokenFromUrl($skipToken);
    }

    public function getData(): Collection
    {
        return $this->data ?? collect();
    }

    public function getSkipToken(): ?string
    {
        return $this->skipToken;
    }

    public function hasMore(): bool
    {
        return ! is_null($this->skipToken);
    }

    private function getSkipTokenFromUrl(?string $url = null): ?string
    {
        if (is_null($url)) {
            return null;
        }

        $parts = parse_url($url);

        if (! isset($parts['query'])) {
            return null;
        }

        parse_str($parts['query'], $query);

        return $query['$skiptoken'] ?? null;
    }
}
