<?php

namespace Daylight\Connector\Exact\Jobs;

use Daylight\Connector\Exact\Entities\ProductPrice;
use Daylight\Core\Models\Customer;
use Daylight\Core\Models\Variant;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateArticlePrice implements ShouldBeEncrypted, ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public ProductPrice $price
    ) {
        //
    }

    public function handle(): void
    {
        $variant = $this->getVariant();

        if (! $variant) {
            return;
        }

        $customer = $this->getCustomer();

        if ($this->price->customerId && ! $customer) {
            return;
        }

        $variant->prices()->updateOrCreate([
            'customer_group_id' => null,
            'customer_id' => $customer?->id,

            'external_id' => $this->price->id,
            'source' => ProductPrice::class,
        ], [
            'price' => $this->price->price,
            'min_quantity' => $this->price->quantity,
            'starts_at' => $this->price->startDate,
            'ends_at' => $this->price->endDate,
        ]);
    }

    public function getVariant(): ?Variant
    {
        return Variant::query()
            ->whereSku($this->price->sku)
            ->first();
    }

    public function getCustomer(): ?Customer
    {
        if (is_null($this->price->customerId)) {
            return null;
        }

        return Customer::query()
            ->whereExternalId($this->price->customerId)
            ->first();
    }
}
