<?php

namespace Daylight\Connector\Exact\Jobs;

use Daylight\Connector\Exact\Entities\PricingList;
use Daylight\Core\Models\CustomerGroup;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdatePricingList implements ShouldBeEncrypted, ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public PricingList $pricingList
    ) {
        //
    }

    public function handle(): void
    {
        CustomerGroup::updateOrCreate([
            'external_id' => $this->pricingList->id,
        ], [
            'name' => $this->pricingList->name,
            'code' => $this->pricingList->code,
            'type' => $this->pricingList->type,
        ]);
    }
}
