<?php

namespace Daylight\Connector\Exact\Jobs;

use Daylight\Connector\Exact\Entities\ProductExtraField;
use Daylight\Core\Models\Variant;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateProductPackaging implements ShouldBeEncrypted, ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public ProductExtraField $extraField
    ) {
        //
    }

    public function handle(): void
    {
        $variant = $this->getVariant();

        if (! $variant) {
            return;
        }

        $variant->update([
            'quantity_step' => filter_var($this->extraField->value, FILTER_SANITIZE_NUMBER_INT),
        ]);
    }

    public function getVariant(): ?Variant
    {
        return Variant::query()
            ->whereExternalId($this->extraField->articleId)
            ->first();
    }
}
