<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\Order;

class OrderMapper implements MapperInterface
{
    public function map(array $data): Order
    {
        return Order::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): Order
    {
        return Order::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
