<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\PricingListLine;

class PricingListLinesMapper implements MapperInterface
{
    public function map(array $data): PricingListLine
    {
        return PricingListLine::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): PricingListLine
    {
        return PricingListLine::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
