<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\PricingListPeriod;

class PricingListPeriodMapper implements MapperInterface
{
    public function map(array $data): PricingListPeriod
    {
        return PricingListPeriod::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): PricingListPeriod
    {
        return PricingListPeriod::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
