<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\Unit;

class UnitMapper implements MapperInterface
{
    public function map(array $data): Unit
    {
        return Unit::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): Unit
    {
        return Unit::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
