<?php

namespace Daylight\Connector\Exact\Requests\Deletion;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\DeletionMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetDeletionsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected DeletionMapper $deletionMapper,
        protected array $options = []
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/sync/Deleted';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                'Timestamp',
                'EntityKey',
                'EntityType',
            ]),
            '$skiptoken' => $this->options['skiptoken'] ?? null,
            '$filter' => isset($this->options['cursor']) ? "Timestamp gt {$this->options['cursor']}L" : null,
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->deletionMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
