<?php

namespace Daylight\Connector\Exact\Requests\PricingLists;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\PricingListPeriodMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetPricingListPeriodsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected PricingListPeriodMapper $pricingListPeriodMapper,
        protected array $options = []
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/sales/SalesPriceListPeriods';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$skiptoken' => $this->options['skiptoken'] ?? null,
            '$filter' => implode(' and ', array_filter([
                'StartDate' => isset($this->options['start_date']) ? "StartDate le datetime'".$this->options['start_date']->toIso8601String()."'" : null,
                'EndDate' => isset($this->options['end_date']) ? "(EndDate ge datetime'".$this->options['start_date']->toIso8601String()."' or EndDate eq null)" : null,
            ])),
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->pricingListPeriodMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
