<?php

namespace Daylight\Connector\Exact\Requests\Products;

use Daylight\Connector\Exact\Mappers\ProductExtraFieldMapper;
use Illuminate\Support\Collection;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetProductExtraFieldsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected ProductExtraFieldMapper $productExtraFieldMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/read/logistics/ItemExtraField';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$filter' => isset($this->options['number']) ? "Number eq {$this->options['number']}" : null,
        ]);
    }

    public function createDtoFromResponse(Response $response): Collection
    {
        $formattedResponse = $response->json('d');

        return collect($formattedResponse ?? [])->map(function (array $item) {
            return $this->productExtraFieldMapper->map($item);
        });
    }
}
