<?php

namespace Daylight\Connector\Exact\Requests\Products;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\ProductPriceMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetProductPricesRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected ProductPriceMapper $productPriceMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/sync/Logistics/SalesItemPrices';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                'Timestamp',
                'Account',
                'Item',
                'ItemCode',
                'Quantity',
                'Price',
                'NumberOfItemsPerUnit',
                'StartDate',
                'EndDate',
            ]),
            '$skiptoken' => $this->options['skiptoken'] ?? null,
            '$filter' => isset($this->options['cursor']) ? "Timestamp gt {$this->options['cursor']}L" : null,
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->productPriceMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
